# Crowd Source Python Client

Python client for receiving accelerometer data from phones and sending control messages.

## Installation

1. Create a virtual environment (recommended):
```bash
python3 -m venv venv
source venv/bin/activate  # On Windows: venv\Scripts\activate
```

2. Install dependencies:
```bash
pip install -r requirements.txt
```

## Usage

### Basic Usage

Connect to a specific room:
```bash
python client.py --room org-slug/room-slug
```

### Specify Custom Server

Connect to a remote server:
```bash
python client.py --room myorg/room1 --server http://YOUR_VPS_IP:3107
```

## Features

### Receiving Data

- Automatically connects to the specified room
- Displays incoming accelerometer data from all phones in the room
- Shows phone ID, X/Y/Z axis values, and timestamp
- Tracks total message count

### Sending Control Messages

While the client is running:
- Type any message and press Enter to send an alert to all phones in the room
- The message will appear as an alert on the phone web apps
- Type `quit`, `exit`, or `q` to disconnect

### Example Session

```
$ python client.py --room myorg/test-room

======================================================================
Crowd Source Python Client
======================================================================
Server: http://localhost:3107
Room:   myorg/test-room
======================================================================

[i] Connecting to server...
[✓] Connected to Socket.IO server
[i] Session ID: abc123xyz
[i] Joining room: myorg/test-room

[i] Room Status: myorg/test-room
    Phones connected: 2
    Time: 14:30:45.123

======================================================================
Commands:
  Type a message and press Enter to send an alert to all phones
  Type 'quit' or 'exit' to disconnect
======================================================================

[   1] Phone: a1b2c3d4... | X:   0.12 | Y:  -0.34 | Z:   9.81 | Time: 14:30:46.234
[   2] Phone: a1b2c3d4... | X:   0.15 | Y:  -0.32 | Z:   9.79 | Time: 14:30:47.245

Hello phones!
[→] Sent control message: alert - Hello phones!

[   3] Phone: a1b2c3d4... | X:   0.13 | Y:  -0.35 | Z:   9.82 | Time: 14:30:48.256
```

## Keyboard Shortcuts

- **Enter**: Send message to phones
- **Ctrl+C**: Graceful shutdown
- **Ctrl+D**: EOF, closes input

## Troubleshooting

### Connection Refused

If you see "Failed to connect to server", make sure:
1. The Socket.IO server is running on the specified port
2. The server URL is correct (include http:// prefix)
3. The port is not blocked by a firewall

### No Data Received

If you're not receiving accelerometer data:
1. Check that phones are connected to the same room
2. Verify phones have started sending data (press "Start Sending" button)
3. Check server logs for connection issues

## Environment

- Python 3.7+
- python-socketio[client] 5.11.4
