"""Data stream tab widget with pause/resume functionality"""

from textual.app import ComposeResult
from textual.containers import Container
from textual.widgets import Static
from textual.reactive import reactive

from widgets.data_stream import DataStream


class DataStreamTab(Container):
    """Data stream tab that wraps DataStream with pause/resume"""

    is_paused: reactive[bool] = reactive(False)

    def compose(self) -> ComposeResult:
        """Create data stream tab widgets"""
        yield DataStream(id="data-stream")

    def pause(self) -> None:
        """Pause data stream updates"""
        self.is_paused = True

    def resume(self) -> None:
        """Resume data stream updates"""
        self.is_paused = False

    def add_data(self, data: dict, message_num: int) -> None:
        """Add data to stream (only if not paused)"""
        if not self.is_paused:
            data_stream = self.query_one("#data-stream", DataStream)
            data_stream.add_data(data, message_num)
