"""Event log tab widget with pause/resume functionality"""

from textual.app import ComposeResult
from textual.containers import Container
from textual.widgets import RichLog
from textual.reactive import reactive


class EventLogTab(Container):
    """Event log tab that wraps RichLog with pause/resume"""

    is_paused: reactive[bool] = reactive(False)

    def compose(self) -> ComposeResult:
        """Create event log tab widgets"""
        yield RichLog(id="event-log", wrap=False, highlight=True, markup=True)

    def pause(self) -> None:
        """Pause event log updates"""
        self.is_paused = True

    def resume(self) -> None:
        """Resume event log updates"""
        self.is_paused = False

    def write(self, message: str) -> None:
        """Write message to log (only if not paused)"""
        if not self.is_paused:
            event_log = self.query_one("#event-log", RichLog)
            event_log.write(message)
